# Generated by Django 5.1.2 on 2025-11-11 12:56

import datetime
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='TarazBanner',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('slug', models.SlugField(blank=True, max_length=255, unique=True)),
                ('image', models.ImageField(blank=True, default='', null=True, upload_to='banner/image/')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='TarazBlog',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('title', models.CharField(max_length=255)),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
                ('content', models.TextField()),
                ('excerpt', models.TextField(blank=True, default='', null=True)),
                ('cover_image', models.ImageField(blank=True, default='', null=True, upload_to='blog/images/')),
                ('author_name', models.CharField(blank=True, default='Admin', max_length=100, null=True)),
                ('author_image', models.ImageField(blank=True, default='', null=True, upload_to='blog/authors/')),
                ('tags', models.JSONField(blank=True, default=list)),
                ('meta_title', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('meta_description', models.CharField(blank=True, default='', max_length=1500, null=True)),
                ('b_meta_description', models.TextField(blank=True, default='', null=True)),
                ('status', models.CharField(choices=[('draft', 'Draft'), ('published', 'Published')], default='draft', max_length=20)),
                ('published_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(blank=True, default=datetime.datetime.now, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('system_date', models.DateTimeField(blank=True, default=datetime.datetime.now, null=True)),
                ('b_title', models.CharField(blank=True, default='', max_length=255)),
                ('b_content', models.TextField(blank=True, default='')),
            ],
        ),
        migrations.CreateModel(
            name='TarazBottomBanner',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('slug', models.SlugField(blank=True, max_length=255, unique=True)),
                ('image', models.ImageField(blank=True, default='', null=True, upload_to='banner/image/')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='TarazCategory',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('value', models.CharField(max_length=255)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='TarazCompanyContact',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('company_name', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('phone', models.CharField(blank=True, default='', max_length=50, null=True)),
                ('email', models.EmailField(blank=True, default='', max_length=150, null=True)),
                ('website', models.URLField(blank=True, default='', max_length=255, null=True)),
                ('address', models.TextField(blank=True, default='', null=True)),
                ('city', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('country', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('facebook', models.URLField(blank=True, default='', max_length=255, null=True)),
                ('instagram', models.URLField(blank=True, default='', max_length=255, null=True)),
                ('youtube', models.URLField(blank=True, default='', max_length=255, null=True)),
                ('linkedin', models.URLField(blank=True, default='', max_length=255, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('system_date', models.DateTimeField(blank=True, default=datetime.datetime.now, null=True)),
                ('b_company_name', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('b_phone', models.CharField(blank=True, default='', max_length=50, null=True)),
                ('b_address', models.TextField(blank=True, default='', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='TarazContact',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=150)),
                ('phone', models.CharField(blank=True, default='', max_length=20, null=True)),
                ('subject', models.CharField(blank=True, default='', max_length=200, null=True)),
                ('message', models.TextField()),
                ('created_at', models.DateTimeField(blank=True, default=datetime.datetime.now, null=True)),
                ('system_date', models.DateTimeField(blank=True, default=datetime.datetime.now, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='TarazFAQ',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('title', models.CharField(max_length=255)),
                ('b_title', models.CharField(max_length=255)),
                ('items', models.JSONField(default=list)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='TarazHitcounter',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('total_visitor', models.IntegerField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='TarazOrder',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('user_id', models.CharField(max_length=20)),
                ('customer_name', models.CharField(max_length=100)),
                ('customer_email', models.EmailField(blank=True, default='', max_length=150, null=True)),
                ('customer_phone', models.CharField(blank=True, default='', max_length=20, null=True)),
                ('delivery_address', models.TextField(blank=True, default='', null=True)),
                ('items_data', models.JSONField(blank=True, default=list)),
                ('total_amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('order_status', models.CharField(choices=[('pending', 'Pending'), ('confirmed', 'Confirmed'), ('shipped', 'Shipped'), ('delivered', 'Delivered'), ('cancelled', 'Cancelled')], default='pending', max_length=50)),
                ('payment_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('payment_currency', models.CharField(default='BDT', max_length=10)),
                ('payment_method', models.CharField(blank=True, max_length=50, null=True)),
                ('payment_status', models.CharField(choices=[('pending', 'Pending'), ('paid', 'Paid'), ('failed', 'Failed')], default='pending', max_length=50)),
                ('transaction_id', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('provider', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('paid_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(blank=True, default=datetime.datetime.now, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('system_date', models.DateTimeField(blank=True, default=datetime.datetime.now, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='TarazProduct',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
                ('offer', models.CharField(blank=True, default='', max_length=50, null=True)),
                ('discount_price', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('original_price', models.DecimalField(blank=True, decimal_places=2, max_digits=10, null=True)),
                ('image1', models.ImageField(blank=True, default='', null=True, upload_to='product/image/')),
                ('image2', models.ImageField(blank=True, default='', null=True, upload_to='product/image/')),
                ('image3', models.ImageField(blank=True, default='', null=True, upload_to='product/image/')),
                ('image4', models.ImageField(blank=True, default='', null=True, upload_to='product/image/')),
                ('image5', models.ImageField(blank=True, default='', null=True, upload_to='product/image/')),
                ('video_link_list', models.JSONField(blank=True, default=list)),
                ('weight', models.CharField(blank=True, default='', max_length=50, null=True)),
                ('category', models.CharField(choices=[('hair_care', 'Hair Care'), ('skin_care', 'Skin Care'), ('makeup', 'Makeup'), ('fragrance', 'Fragrance'), ('body_care', 'Body Care'), ('others', 'Others')], default='others', max_length=100)),
                ('type', models.CharField(blank=True, default='', max_length=100, null=True)),
                ('product_details', models.TextField(blank=True, default='', null=True)),
                ('description', models.TextField(blank=True, default='', null=True)),
                ('reviews', models.JSONField(blank=True, default=list)),
                ('system_date', models.DateTimeField(blank=True, default=datetime.datetime.now, null=True)),
                ('b_name', models.CharField(blank=True, default='', max_length=255)),
                ('b_description', models.TextField(blank=True, default='', null=True)),
                ('meta_description', models.TextField(blank=True, default='', null=True)),
                ('b_meta_description', models.TextField(blank=True, default='', null=True)),
                ('tags', models.JSONField(blank=True, default=list, null=True)),
                ('categories', models.JSONField(blank=True, default=list)),
                ('views', models.IntegerField(blank=True, default=0)),
                ('faqs', models.JSONField(blank=True, default=list, null=True)),
                ('pin', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='TarazUser',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=150, unique=True)),
                ('password_hash', models.CharField(max_length=255)),
                ('phone', models.CharField(blank=True, default='', max_length=20, null=True)),
                ('address', models.TextField(blank=True, default='', null=True)),
                ('image', models.ImageField(blank=True, default='', null=True, upload_to='user/image/')),
                ('role', models.CharField(choices=[('user', 'User'), ('admin', 'Admin')], default='user', max_length=50)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(blank=True, default=datetime.datetime.now, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('system_date', models.DateTimeField(blank=True, default=datetime.datetime.now, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='TarazVideo',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('title', models.CharField(max_length=255)),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
                ('thumbnail', models.URLField(blank=True, default='', max_length=500, null=True)),
                ('video_id', models.CharField(blank=True, default='', max_length=500, null=True)),
                ('pin', models.BooleanField(default=False)),
                ('system_date', models.DateTimeField(blank=True, default=datetime.datetime.now, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='TarazWebsiteTitle',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('page_name', models.CharField(max_length=255)),
                ('title', models.CharField(max_length=255)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('b_title', models.CharField(blank=True, default='', max_length=255)),
            ],
        ),
    ]
