from django.shortcuts import render
from rest_framework import generics
from rest_framework.pagination import PageNumberPagination

# Tarazwebsite1
from mainapp.models import (
    TarazUser,
    TarazProduct,
    TarazVideo,
    TarazOrder,
    TarazBlog,
    TarazContact,
    TarazCompanyContact,
    TarazBanner,
    TarazBottomBanner,
    TarazWebsiteTitle,
    TarazFAQ,
    TarazHitcounter,
    TarazCategory,
)

# TarazWebsite1
from .serializers import (
    TarazUserSerializers,
    TarazProductSerializers,
    TarazVideoSerializers,
    TarazOrderSerializers,
    TarazBlogSerializers,
    TarazContactSerializers,
    TarazCompanyContactSerializers,
    TarazBannerSerializers,
    TarazBottomBannerSerializers,
    TarazWebsiteTitleSerializers,
    TarazFAQSerializers,
    TarazHitcounterSerializers,
    TarazCategorySerializers,
)

# TarazUser
class SeeTarazUser(generics.ListAPIView):
    queryset = TarazUser.objects.all()
    serializer_class = TarazUserSerializers


class UpdateTarazUser(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazUser.objects.all()
    serializer_class = TarazUserSerializers


class CreateTarazUser(generics.ListCreateAPIView):
    queryset = TarazUser.objects.all().order_by('-id')[:1]
    serializer_class = TarazUserSerializers


# TarazProduct
class SeeTarazProduct(generics.ListAPIView):
    queryset = TarazProduct.objects.all()
    serializer_class = TarazProductSerializers


class UpdateTarazProduct(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazProduct.objects.all()
    serializer_class = TarazProductSerializers


class CreateTarazProduct(generics.ListCreateAPIView):
    queryset = TarazProduct.objects.all().order_by('-id')[:1]
    serializer_class = TarazProductSerializers


# TarazVideo
class SeeTarazVideo(generics.ListAPIView):
    queryset = TarazVideo.objects.all()
    serializer_class = TarazVideoSerializers


class UpdateTarazVideo(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazVideo.objects.all()
    serializer_class = TarazVideoSerializers


class CreateTarazVideo(generics.ListCreateAPIView):
    queryset = TarazVideo.objects.all().order_by('-id')[:1]
    serializer_class = TarazVideoSerializers


# TarazOrder
class SeeTarazOrder(generics.ListAPIView):
    queryset = TarazOrder.objects.all()
    serializer_class = TarazOrderSerializers


class UpdateTarazOrder(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazOrder.objects.all()
    serializer_class = TarazOrderSerializers


class CreateTarazOrder(generics.ListCreateAPIView):
    queryset = TarazOrder.objects.all().order_by('-id')[:1]
    serializer_class = TarazOrderSerializers


# TarazBlog
class SeeTarazBlog(generics.ListAPIView):
    queryset = TarazBlog.objects.all()
    serializer_class = TarazBlogSerializers


class UpdateTarazBlog(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazBlog.objects.all()
    serializer_class = TarazBlogSerializers


class CreateTarazBlog(generics.ListCreateAPIView):
    queryset = TarazBlog.objects.all().order_by('-id')[:1]
    serializer_class = TarazBlogSerializers


# TarazContact
class SeeTarazContact(generics.ListAPIView):
    queryset = TarazContact.objects.all()
    serializer_class = TarazContactSerializers


class UpdateTarazContact(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazContact.objects.all()
    serializer_class = TarazContactSerializers


class CreateTarazContact(generics.ListCreateAPIView):
    queryset = TarazContact.objects.all().order_by('-id')[:1]
    serializer_class = TarazContactSerializers


# TarazCompanyContact
class SeeTarazCompanyContact(generics.ListAPIView):
    queryset = TarazCompanyContact.objects.all()
    serializer_class = TarazCompanyContactSerializers


class UpdateTarazCompanyContact(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazCompanyContact.objects.all()
    serializer_class = TarazCompanyContactSerializers


class CreateTarazCompanyContact(generics.ListCreateAPIView):
    queryset = TarazCompanyContact.objects.all().order_by('-id')[:1]
    serializer_class = TarazCompanyContactSerializers


# TarazBanner
class SeeTarazBanner(generics.ListAPIView):
    queryset = TarazBanner.objects.all()
    serializer_class = TarazBannerSerializers


class UpdateTarazBanner(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazBanner.objects.all()
    serializer_class = TarazBannerSerializers


class CreateTarazBanner(generics.ListCreateAPIView):
    queryset = TarazBanner.objects.all().order_by('-id')[:1]
    serializer_class = TarazBannerSerializers


# TarazBottomBanner
class SeeTarazBottomBanner(generics.ListAPIView):
    queryset = TarazBottomBanner.objects.all()
    serializer_class = TarazBottomBannerSerializers


class UpdateTarazBottomBanner(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazBottomBanner.objects.all()
    serializer_class = TarazBottomBannerSerializers


class CreateTarazBottomBanner(generics.ListCreateAPIView):
    queryset = TarazBottomBanner.objects.all().order_by('-id')[:1]
    serializer_class = TarazBottomBannerSerializers


# TarazWebsiteTitle
class SeeTarazWebsiteTitle(generics.ListAPIView):
    queryset = TarazWebsiteTitle.objects.all()
    serializer_class = TarazWebsiteTitleSerializers


class UpdateTarazWebsiteTitle(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazWebsiteTitle.objects.all()
    serializer_class = TarazWebsiteTitleSerializers


class CreateTarazWebsiteTitle(generics.ListCreateAPIView):
    queryset = TarazWebsiteTitle.objects.all().order_by('-id')[:1]
    serializer_class = TarazWebsiteTitleSerializers


# TarazFAQ
class SeeTarazFAQ(generics.ListAPIView):
    queryset = TarazFAQ.objects.all()
    serializer_class = TarazFAQSerializers


class UpdateTarazFAQ(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazFAQ.objects.all()
    serializer_class = TarazFAQSerializers


class CreateTarazFAQ(generics.ListCreateAPIView):
    queryset = TarazFAQ.objects.all().order_by('-id')[:1]
    serializer_class = TarazFAQSerializers


# TarazHitcounter
class SeeTarazHitcounter(generics.ListAPIView):
    queryset = TarazHitcounter.objects.all()
    serializer_class = TarazHitcounterSerializers


class UpdateTarazHitcounter(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazHitcounter.objects.all()
    serializer_class = TarazHitcounterSerializers


class CreateTarazHitcounter(generics.ListCreateAPIView):
    queryset = TarazHitcounter.objects.all().order_by('-id')[:1]
    serializer_class = TarazHitcounterSerializers


# TarazCategory
class SeeTarazCategory(generics.ListAPIView):
    queryset = TarazCategory.objects.all()
    serializer_class = TarazCategorySerializers


class UpdateTarazCategory(generics.RetrieveUpdateDestroyAPIView):
    queryset = TarazCategory.objects.all()
    serializer_class = TarazCategorySerializers


class CreateTarazCategory(generics.ListCreateAPIView):
    queryset = TarazCategory.objects.all().order_by('-id')[:1]
    serializer_class = TarazCategorySerializers
